---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：109-API Resources表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` - api-resourcesソース
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiversions.go` - api-versionsソース
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Discovery APIからリソース一覧取得 | E-01 (180行目) | ○ |
| C-02 | キャッシュ制御: デフォルトでInvalidate | E-01 (174-177行目) | ○ |
| C-03 | --sort-by: name/kindのみ | E-01 (120-127行目) | ○ |
| C-04 | Verbs空のリソース除外 | E-01 (204-206行目) | ○ |
| C-05 | --api-group フィルタ | E-01 (208-210行目) | ○ |
| C-06 | --namespaced フィルタ | E-01 (212-214行目) | ○ |
| C-07 | --verbs フィルタ | E-01 (216-218行目) | ○ |
| C-08 | --categories フィルタ | E-01 (220-222行目) | ○ |
| C-09 | ソートロジック（グループ->リソース名） | E-01 (272-290行目) | ○ |
| C-10 | wide出力でVERBS/CATEGORIESカラム追加 | E-01 (257-258行目) | ○ |
| C-11 | フラグ変更検出（Changed） | E-01 (141-142行目) | ○ |
| C-12 | api-versions: ServerGroups使用 | E-02 (86行目) | ○ |
| C-13 | api-versions: 常にInvalidate | E-02 (84行目) | ○ |
| C-14 | api-versions: アルファベット順ソート | E-02 (91行目) | ○ |
| C-15 | api-versions: 引数不可 | E-02 (73-75行目) | ○ |
| C-16 | 画面マッピング: 画面No.32 | E-03 (74-75行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の情報表示

## 6) レビュアーチェックリスト（最小）
- [ ] Discovery API のエラー時の部分結果表示が適切か確認
- [ ] CRD登録直後のキャッシュ無効化が正しく動作するか確認
